#                 Модель транспорта ауксина ткани
#              
#  dx(1)/dt = DD*[-x(1) + x(2)] + DK*x(1) - Q0*F(x(1))
#                 j=2,3,...,N-1,
#  dx(j)/dt = DD[x(j-1) - 2*x(j) + x(j+1)] - DK*x(j) - Q0*[F(x(j)) - F(x(j-1))]
#  dx(N) = DD*[x(N-1) - x(N)] - DK*x(N) + Q0*F(x(N-1))
#  где
#  F(y) = y*H(y), H(y) - фукция Хилла:
#
#          H(y) = (y/Q1)^P1/[1 + (y/Q2)^P2]/[1 + (y/Q3)^P3].
#
# Параметры модели:    
      DD := p[1];
      DK := p[2];
      AA := p[3];
      Q0 := p[4];
      Q1 := p[5];
      Q2 := p[6];
      Q3 := p[7];
      P1 := p[8];
      P2 := p[9];
      P3 := p[10];
      
      B1 := Q1 ^ (-P1);
      B2 := Q2 ^ (-P2);
      B3 := Q3 ^ (-P3);

      U1 := x[1] ^ P1;
      U2 := x[1] ^ P2;
      U3 := x[1] ^ P3;
      ZU := (1 + B2 * U2) * (1 + B3 * U3);
      FU := B1 * U1 / ZU;
      SS := AA - (DD + DK) * x[1] + DD * x[2];

# NDIM - число уравнений      
      NDIM := 52;

# Правые части автономной системы уравнений:       
      f[1] := SS - Q0 * FU * x[1];
      for i from 2 by 1 to NDIM - 1 do
         V1 := x[i] ^ P1;
         V2 := x[i] ^ P2;
         V3 := x[i] ^ P3;
         ZV := (1 + B2 * V2) * (1 + B3 * V3);
         FV := B1 * V1 / ZV;
         SS := DD * x[i - 1] - (2 * DD + DK) * x[i] + DD * x[i + 1];
         f[i] := SS - Q0 * (FV * x[i] - FU * x[i - 1]);
         FU := FV;
      od;
      SS := DD * x[NDIM - 1] - (DD + DK) * x[NDIM];
      f[NDIM] := SS + Q0 * FV * x[NDIM - 1];