# Model:  'Grain'
#                 0<=t<=1, D=d/dt
#       DD[y] + q*(c - y)*exp(y/(1+b*y) = 0
#       D[y] = 0 при t = 0; y = 0 при t = 1 

# Parameters of Model
q := p[1];
c := p[2];
b := p[3];

# Combinations of Parameters

# Right Parts of the Equations
n := 50;
h := 1 / n;
z := 1 / h^2;

f[1] := 2 * z * (x[2] - x[1]) + q * (c - x[1]) * exp(x[1] / (1 + b * x[1]));
for i from 2 by 1 to n - 1 do
f[i] := z * (x[i - 1] - 2 * x[i] + x[i + 1]) + q * (c - x[i]) * exp(x[i] / (1 + b * x[i]));
od;
f[n] := z * (x[n - 1] - 2 * x[n]) + q * (c - x[n]) * exp(x[n] / (1 + b * x[n]));
