#  Каскад из двух неизотермических проточных реакторов 
#  с полным перемешиванием и рециклом 
#     М.Холодниок, А.Клич, М.Кубичек, М.Марек
#  МЕТОДЫ АНАЛИЗА НЕЛИНЕЙНЫХ ДИНАМИЧЕСКИХ МОДЕЛЕЙ 

#  Формулировка модели 
#                   t > 0, D = d/dt 
#  D[x[1]] = (1 - ALFA) * x[3] - x[1] + WR1
#  D[x[2]] = (1 - ALFA) * x[4] - x[2] + BB * WR1 - BETA * (x[2] - TETA1)
#  D[x[3]] = (x[1] - x[3] + WR2) / QAPA
#  D[x[4]] = (x[2] - x[4] + BB * WR2 - BETA * (x[4] - TETA2)) / QAPA

#  где
#              WR1 = Da * (1 - x[1]) * EX1
#              WR2 = Da * (1 - x[3]) * EX2
#              EX1 = exp(x[2] / (1 + x[2] / GAMA))
#              EX2 = exp(x[4] / (1 + x[4] / GAMA))

#  Параметры модели
ALFA := p[1];
BETA := p[2];
GAMA := p[3];
QAPA := p[4];
BB   := p[5];
TETA1:= p[6];
TETA2:= p[7];
Da   := p[8]; 

EX1 := exp(x[2] / (1 + x[2] / GAMA));
EX2 := exp(x[4] / (1 + x[4] / GAMA));
WR1 := Da * (1 - x[1]) * EX1;
WR2 := Da * (1 - x[3]) * EX2;

f[1] := (1 - ALFA) * x[3] - x[1] + WR1;
f[2] := (1 - ALFA) * x[4] - x[2] + BB * WR1 - BETA * (x[2] - TETA1);
f[3] := (x[1] - x[3] + WR2) / QAPA;
f[4] := (x[2] - x[4] + BB * WR2 - BETA * (x[4] - TETA2)) / QAPA;